package com.qboxus.tictic.activitesfragments.spaces.utils.RoomManager;

import android.os.Parcel;
import android.os.Parcelable;

import com.qboxus.tictic.activitesfragments.spaces.models.HomeUserModel;

import java.io.Serializable;
import java.util.ArrayList;

public class MainStreamingModel implements Parcelable {
    StreamModel model;
    ArrayList<HomeUserModel> userList;

    public MainStreamingModel() {
    }

    protected MainStreamingModel(Parcel in) {
        model = in.readParcelable(StreamModel.class.getClassLoader());
        userList = in.createTypedArrayList(HomeUserModel.CREATOR);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(model, flags);
        dest.writeTypedList(userList);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<MainStreamingModel> CREATOR = new Creator<MainStreamingModel>() {
        @Override
        public MainStreamingModel createFromParcel(Parcel in) {
            return new MainStreamingModel(in);
        }

        @Override
        public MainStreamingModel[] newArray(int size) {
            return new MainStreamingModel[size];
        }
    };

    public StreamModel getModel() {
        return model;
    }

    public void setModel(StreamModel model) {
        this.model = model;
    }

    public ArrayList<HomeUserModel> getUserList() {
        return userList;
    }

    public void setUserList(ArrayList<HomeUserModel> userList) {
        this.userList = userList;
    }
}
